//Experiment-3
// windows - 7 - 64-Bit
//Scilab - 5.4.1


//AIM:  Develop a program to plot torque-speed characteristics of single phase half controlled rectifier fed separately excited DC motor
clear
clc

Vs=230;              // SUPPLY VOLTAGE IN VOLT
Va=220;              //ARMATURE VOLTAGE IN VOLT
f=50;                // FREQUENCY IN Hz
Wr=1500*%pi/30;       // RATED SPEED IN r.p.s.
Ia=11.6;             // ARMATURE CURRENT IN AMP
Ra=2;                // ARMATURE RESISTANCE IN OHM
La=28.36e-3;         // ARMAURE INDUCTANCE IN HENRY

Vm=Vs*sqrt(2);       //MAXIMUM VOLTAGE IN VOLT
E=Va-Ia*Ra;          // BACK EMF IN VOLT  
Tr=E*Ia/Wr;         // RATED TORQUE IN Nm

K=E/Wr;
Wmo=Vm/K;            // NO LOAD SPEED IN r.p.s.
w=2*%pi*f;

Z=sqrt(Ra^2+(w*La)^2); // Calculation of impedance
fai=atan((w*La)/Ra); 
                
j=1;
for alpha=30                                   // For  Firing angle = 30 degree
    alphar=alpha*%pi/180;
    i=1;
    for Wm=0.01:10:Wmo
        Wmi(j,i)=Wm;
        a=%pi+alphar;
        ia=(Vm*exp(-(alphar)*cotg(fai))*(sin(fai)-sin(alphar-fai))/Z)-(E*exp(-(alphar)*cotg(fai))/Ra);
        if ia<=0 then
        for b=(alpha+0.1):0.1:360
            betar=b*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
            if ia<=1e-4 then
                break;
            end
        end
            Tor1(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
            Tor1(j,i)=((Vm*K*(1+cos(alphar))/pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
    j=j+1;
end
plot(Wmi',Tor1','r','LineWidth',2)

for alpha=60                                   // For  Firing angle = 60 degree
    alphar=alpha*%pi/180;
    i=1;
    for Wm=0.01:10:Wmo
        Wmi(j,i)=Wm;
        a=%pi+alphar;
        ia=(Vm*exp(-(alphar)*cotg(fai))*(sin(fai)-sin(alphar-fai))/Z)-(E*exp(-(alphar)*cotg(fai))/Ra);
        if ia<=0 then
        for b=(alpha+0.1):0.1:360
            betar=b*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
            if ia<=1e-4 then
                break;
            end
        end
            Tor2(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
            Tor2(j,i)=((Vm*K*(1+cos(alphar))/pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
    j=j+1;
end
plot(Wmi',Tor2','k','LineWidth',2)
for alpha=90                                   // For  Firing angle = 90 degree
    alphar=alpha*%pi/180;
    i=1;
    for Wm=0.01:10:Wmo
        Wmi(j,i)=Wm;
        a=%pi+alphar;
        ia=(Vm*exp(-(alphar)*cotg(fai))*(sin(fai)-sin(alphar-fai))/Z)-(E*exp(-(alphar)*cotg(fai))/Ra);
        if ia<=0 then
        for b=(alpha+0.1):0.1:360
            betar=b*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
            if ia<=1e-4 then
                break;
            end
        end
            Tor3(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
            Tor3(j,i)=((Vm*K*(1+cos(alphar))/pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
    j=j+1;
end
plot(Wmi',Tor3','b','LineWidth',2)

for alpha=120                                   // For  Firing angle = 120 degree
    alphar=alpha*%pi/180;
    i=1;
    for Wm=0.01:10:Wmo
        Wmi(j,i)=Wm;
        a=%pi+alphar;
        ia=(Vm*exp(-(alphar)*cotg(fai))*(sin(fai)-sin(alphar-fai))/Z)-(E*exp(-(alphar)*cotg(fai))/Ra);
        if ia<=0 then
        for b=(alpha+0.1):0.1:360
            betar=b*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
            if ia<=1e-4 then
                break;
            end
        end
            Tor4(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
          Tor4(j,i)=((Vm*K*(1+cos(alphar))/pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
    j=j+1;
end

plot(Wmi',Tor4','c','LineWidth',2)

title(' Torque-Speed characteristics of single phase half controlled rectifier fed separately excited DC motor','fontsize',3)
xlabel("SPEED--------->",'fontsize',3)
ylabel("TORQUE--------->",'fontsize',3)
xgrid
legend('Firing Angle =30 degree','Firing Angle =60 degree','','Firing Angle =90 degree','','','Firing Angle =120 degree')
